/*
 * Decompiled with CFR 0.152.
 */
package org.curiositycollective.onepixelwebcam;

import com.apple.cocoa.application.NSApplication;
import com.apple.cocoa.foundation.NSAppleEventDescriptor;
import com.apple.cocoa.foundation.NSAppleScript;
import com.apple.cocoa.foundation.NSMutableDictionary;
import java.awt.Color;
import java.awt.TextField;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.curiositycollective.onepixelwebcam.PixelListener;

public class AppleScriptOutput
extends TextField
implements PixelListener {
    String mainScript = new String();

    AppleScriptOutput(String file) throws ClassNotFoundException, IOException {
        this.init(file);
    }

    AppleScriptOutput(File file) throws ClassNotFoundException, IOException {
        this.init(file);
    }

    public void runScript(String script) {
        System.out.println(script);
        NSApplication.sharedApplication();
        NSAppleScript myScript = new NSAppleScript(script);
        NSMutableDictionary errors = new NSMutableDictionary();
        myScript.compile(errors);
        NSAppleEventDescriptor nsAppleEventDescriptor = myScript.execute(errors);
        System.out.println("> " + nsAppleEventDescriptor.stringValue());
    }

    private void init(String file) throws IOException {
        this.init(new File(file));
    }

    private void init(File file) throws IOException {
        this.loadScript(file);
        this.setText(file.toString());
    }

    private void loadScript(File file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        do {
            if ((line = reader.readLine()) == null) continue;
            this.mainScript = String.valueOf(this.mainScript) + line + '\n';
        } while (line != null);
        reader.close();
    }

    public void pixelUpdate(Color c) {
        String setColorScript = new String();
        setColorScript = String.valueOf(setColorScript) + "set red to " + c.getRed() + '\n';
        setColorScript = String.valueOf(setColorScript) + "set green to " + c.getGreen() + '\n';
        setColorScript = String.valueOf(setColorScript) + "set blue to " + c.getBlue() + '\n';
        this.runScript(String.valueOf(setColorScript) + this.mainScript);
    }

    public void pixelReset() {
    }

    public static boolean available() {
        boolean available = true;
        try {
            Class.forName("com.apple.cocoa.application.NSApplication");
        }
        catch (ClassNotFoundException e) {
            available = false;
        }
        return available;
    }
}

