/*
 * Decompiled with CFR 0.152.
 */
package org.curiositycollective.onepixelwebcam;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import org.curiositycollective.onepixelwebcam.ColorChart;
import org.curiositycollective.onepixelwebcam.PixelListener;

public class BackgroundImage
extends BufferedImage
implements PixelListener {
    private File thisOutputDirectory = null;
    private ColorChart chart = new ColorChart();
    private BufferedImage watermark = null;

    public BackgroundImage(int width, int height) {
        super(width, height, 1);
        try {
            this.init(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BackgroundImage(int width, int height, File outputDirectory) throws Exception {
        super(width, height, 1);
        this.init(outputDirectory);
    }

    private void init(File outputDirectory) throws Exception {
        this.setOutputDirectory(outputDirectory);
        Panel c = new Panel();
        URL watermarkURL = this.getClass().getResource("/org/curiositycollective/onepixelwebcam/watermark.jpg");
        this.watermark = BackgroundImage.createBufferedImage(Toolkit.getDefaultToolkit().getImage(watermarkURL), c);
    }

    public void setOutputDirectory(File outputDirectory) throws Exception {
        if (outputDirectory == null) {
            this.thisOutputDirectory = null;
        } else if (outputDirectory.isDirectory()) {
            this.thisOutputDirectory = outputDirectory;
        } else {
            throw new Exception(String.valueOf(outputDirectory.toString()) + " is not a diirectory");
        }
    }

    public void setColor(Color c) {
        Graphics2D graphics = this.createGraphics();
        graphics.setColor(c);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.chart.addColor(c);
        int numberOfColors = this.chart.getNumberOfColors();
        int chartHeight = (int)((float)this.getHeight() * 0.05f);
        int chartWidth = 4 * this.getWidth() / 6;
        int xoffset = 1 * this.getWidth() / 6;
        int yoffset = this.getHeight() / 2 - chartHeight / 2;
        if (this.chart.getNumberOfColors() > 1) {
            int width = chartWidth / (this.chart.getNumberOfColors() - 1);
            int n = 0;
            while (n < this.chart.getNumberOfColors() - 1) {
                graphics.setColor(this.chart.getColor(n));
                graphics.fillRect(xoffset + width * n, yoffset, width, chartHeight);
                ++n;
            }
        }
        this.addWatermark();
    }

    public void save(String filename) throws IOException {
        this.save(this.thisOutputDirectory, filename);
    }

    public void save(File directory, String filename) throws IOException {
        File file = new File(directory, filename);
        FileOutputStream fos = new FileOutputStream(file);
        JPEGImageEncoder jpeg = JPEGCodec.createJPEGEncoder((OutputStream)fos);
        JPEGEncodeParam param = jpeg.getDefaultJPEGEncodeParam((BufferedImage)this);
        float quality = 1.0f;
        param.setQuality(quality, false);
        jpeg.setJPEGEncodeParam(param);
        jpeg.encode((BufferedImage)this);
        fos.close();
    }

    public void pixelUpdate(Color c) {
        this.setColor(c);
        try {
            this.save("background.jpg");
            this.save("background-copy.jpg");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void pixelReset() {
        this.chart.reset();
    }

    public void addWatermark() {
        Color imagePixel = null;
        Color watermarkPixel = null;
        int r = 0;
        int g = 0;
        int b = 0;
        int x = 0;
        while (x < this.getWidth()) {
            int y = 0;
            while (y < this.getHeight()) {
                imagePixel = new Color(this.getRGB(x, y));
                watermarkPixel = new Color(this.watermark.getRGB(x, y));
                try {
                    r = watermarkPixel.getRed() - 128 + imagePixel.getRed();
                    g = watermarkPixel.getGreen() - 128 + imagePixel.getGreen();
                    b = watermarkPixel.getBlue() - 128 + imagePixel.getBlue();
                    r = r > 256 ? 256 : r;
                    r = r < 0 ? 0 : r;
                    g = g > 256 ? 256 : g;
                    g = g < 0 ? 0 : g;
                    b = b > 256 ? 256 : b;
                    b = b < 0 ? 0 : b;
                    imagePixel = new Color(r, g, b);
                    this.setRGB(x, y, imagePixel.getRGB());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                ++y;
            }
            ++x;
        }
    }

    public static BufferedImage createBufferedImage(Image imageIn, Component comp) {
        return BackgroundImage.createBufferedImage(imageIn, 2, comp);
    }

    public static BufferedImage createBufferedImage(Image imageIn, int imageType, Component comp) {
        MediaTracker mt = new MediaTracker(comp);
        mt.addImage(imageIn, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        BufferedImage bufferedImageOut = new BufferedImage(imageIn.getWidth(null), imageIn.getHeight(null), imageType);
        Graphics g = bufferedImageOut.getGraphics();
        g.drawImage(imageIn, 0, 0, null);
        return bufferedImageOut;
    }
}

