/*
 * Decompiled with CFR 0.152.
 */
package org.curiositycollective.onepixelwebcam;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import org.curiositycollective.onepixelwebcam.ColorChart;
import org.curiositycollective.onepixelwebcam.PixelListener;

public class ColorChartCanvas
extends Canvas
implements PixelListener {
    private int width = 0;
    private int height = 0;
    private ColorChart chart = new ColorChart();

    public ColorChartCanvas(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void setColor(Color c) {
        this.chart.addColor(c);
        this.invalidate();
        this.repaint();
    }

    public void pixelUpdate(Color c) {
        this.setColor(c);
    }

    public void pixelReset() {
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension(this.width, this.height);
        return preferredSize;
    }

    public void paint(Graphics graphics) {
        int i = 0;
        while (i < this.chart.getNumberOfColors()) {
            graphics.setColor(this.chart.getColor(i));
            int barWidth = this.width / this.chart.getNumberOfColors();
            graphics.fillRect(i * barWidth, 0, barWidth, this.height);
            ++i;
        }
    }
}

