/*
 * Decompiled with CFR 0.152.
 */
package org.curiositycollective.onepixelwebcam;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.curiositycollective.onepixelwebcam.URLField;

public class ImageURLField
extends URLField {
    private URL thisURL = null;

    public ImageURLField(String url, int w, int h) throws MalformedURLException {
        super(w, h);
        String protocol = null;
        String protocolSeparator = "://";
        int protocolSeparatorIndex = url.indexOf(protocolSeparator);
        if (protocolSeparatorIndex > 0) {
            protocol = url.substring(0, protocolSeparatorIndex);
        }
        System.out.println("protocol: " + protocol);
        this.init(new URL(url));
    }

    public ImageURLField(URL url, String proxy, int w, int h) {
        super(w, h);
        this.init(url);
    }

    public ImageURLField(URL url, int w, int h) {
        super(w, h);
        this.init(url);
    }

    private void init(URL url) {
        this.setURL(url);
    }

    public void setURL(String url) throws MalformedURLException {
        this.setURL(new URL(url));
    }

    public void setURL(URL url) {
        if (url != null && ImageURLField.isImage(url)) {
            super.setURL(url);
        } else {
            try {
                if (ImageURLField.isHTML(url)) {
                    this.setURL(this.findImageInWebpage(url));
                }
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
    }

    public URL findImageInWebpage(URL webpage) throws Exception {
        String inputLine;
        URL url = null;
        URLConnection c = webpage.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(c.getInputStream()));
        Matcher widthTag = null;
        Matcher heightTag = null;
        Matcher sourceTag = null;
        int largestArea = 0;
        String largestImage = null;
        while ((inputLine = in.readLine()) != null) {
            String[] token = inputLine.split("<|>");
            int i = 0;
            while (i < token.length) {
                sourceTag = Pattern.compile("^img.*src(\\s)*=\"(\\S+)\"\\s(.)*$").matcher(token[i]);
                widthTag = Pattern.compile("^img.*width(\\D)*(\\d+)(.)*$").matcher(token[i]);
                heightTag = Pattern.compile("^img.*height(\\D)*(\\d+)(.)*$").matcher(token[i]);
                if (sourceTag.matches() && widthTag.matches() && heightTag.matches()) {
                    int width = Integer.parseInt(widthTag.group(2));
                    int height = Integer.parseInt(heightTag.group(2));
                    int area = width * height;
                    String source = sourceTag.group(2);
                    if (area > largestArea) {
                        largestArea = area;
                        largestImage = source;
                    }
                }
                ++i;
            }
        }
        in.close();
        if (!largestImage.startsWith("http://")) {
            String path = "http://" + webpage.getHost();
            if (!largestImage.startsWith("/")) {
                path = String.valueOf(path) + webpage.getPath();
            }
            largestImage = String.valueOf(path) + largestImage;
        }
        url = new URL(largestImage);
        System.out.println(url);
        return url;
    }

    public static boolean isImage(URL url) {
        boolean result = false;
        try {
            if (ImageURLField.getContentType(url).startsWith("image/")) {
                result = true;
            }
        }
        catch (Exception ioe) {
            result = false;
        }
        return result;
    }

    public static boolean isHTML(URL url) {
        boolean result = false;
        try {
            if (ImageURLField.getContentType(url).startsWith("text/html")) {
                result = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static String getContentType(URL url) throws IOException {
        URLConnection c = url.openConnection();
        return c.getContentType();
    }
}

