/*
 * Decompiled with CFR 0.152.
 */
package org.curiositycollective.onepixelwebcam;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.curiositycollective.onepixelwebcam.AppleScriptOutput;
import org.curiositycollective.onepixelwebcam.BackgroundImage;
import org.curiositycollective.onepixelwebcam.MacOSAppAdapter;
import org.curiositycollective.onepixelwebcam.PixelListener;
import org.curiositycollective.onepixelwebcam.TimeSlider;
import org.curiositycollective.onepixelwebcam.URLField;
import org.curiositycollective.onepixelwebcam.WebCamPanel;

public class OnePixelWebCam
extends JFrame
implements Runnable,
PixelListener,
ChangeListener,
ComponentListener,
WindowListener {
    private String preferenceFile = "OnePixelWebCam.prefs.txt";
    private AppleScriptOutput applescriptField = null;
    private WebCamPanel webCamPanel = null;
    private BackgroundImage bg = null;
    private URLField outputField = new URLField(300, 30);
    private TimeSlider slider = null;
    private Thread imageRefreshThread = null;

    public OnePixelWebCam(URL imageURL, int onePixelX, int onePixelY, int interval, File outputDirectory) {
        this.init(imageURL, new Point(onePixelX, onePixelY), interval, outputDirectory);
    }

    public OnePixelWebCam(URL imageURL, Point onePixel, int interval, File outputDirectory) {
        this.init(imageURL, onePixel, interval, outputDirectory);
    }

    public OnePixelWebCam() {
        try {
            this.init();
        }
        catch (IOException ioe) {
            this.init(null, null, this.webCamPanel.getInterval(), null);
        }
    }

    public OnePixelWebCam(URL imageURL) {
        this.init(imageURL);
    }

    private void init(URL imageURL) {
        this.init(imageURL, null, this.webCamPanel.getInterval(), null);
    }

    private void init(URL imageURL, Point onePixel, long interval, File outputDirectory) {
        this.setTitle("OnePixelWebCam");
        this.addComponentListener(this);
        this.addWindowListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.webCamPanel = new WebCamPanel(imageURL, onePixel);
        this.getContentPane().add((Component)this.webCamPanel, "Center");
        JPanel outputPane = new JPanel(new BorderLayout());
        outputPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Pick an Interval"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.getContentPane().add((Component)outputPane, "Last");
        this.outputField.setText("blah");
        this.setInterval(interval);
        this.slider = new TimeSlider(interval);
        this.slider.addChangeListener(this);
        outputPane.add((Component)this.slider, "First");
        this.pack();
        this.setVisible(true);
        try {
            this.bg = new BackgroundImage(1024, 768, new File("./"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.webCamPanel.addPixelListener(this.bg);
        this.startImageRefreshThread();
    }

    public void init() throws IOException {
        this.init(new File(this.preferenceFile));
        new MacOSAppAdapter(this);
    }

    public void init(File file) throws IOException, MalformedURLException {
        URL url = null;
        Point point = null;
        int interval = 6000;
        long nextRefreshDue = 0L;
        try {
            if (file.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = reader.readLine();
                reader.close();
                String[] token = line.split("\t");
                url = new URL(token[0]);
                int x = Integer.parseInt(token[1]);
                int y = Integer.parseInt(token[2]);
                point = new Point(x, y);
                interval = Integer.parseInt(token[3]);
                nextRefreshDue = Long.parseLong(token[4]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init(url, point, interval, null);
    }

    private boolean initComplete() {
        boolean result = false;
        return result;
    }

    public void savePreferences() throws IOException {
        this.savePreferences(new File(this.preferenceFile));
    }

    public void savePreferences(File file) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        System.out.println("OnePixelWebCam::savePreferences");
        this.savePreferences(writer);
        writer.flush();
        writer.close();
    }

    public void savePreferences(BufferedWriter writer) throws IOException {
        this.webCamPanel.savePreferences(writer);
    }

    private void startImageRefreshThread() {
        if (this.imageRefreshThread == null) {
            this.imageRefreshThread = new Thread(this);
            this.imageRefreshThread.start();
        }
    }

    public void pixelUpdate(Color c) {
    }

    public void pixelReset() {
    }

    public long getInterval() {
        return this.webCamPanel.getInterval();
    }

    public void setInterval(long t) {
        this.webCamPanel.setInterval(t);
    }

    public long getNextRefreshDue() {
        return this.webCamPanel.getNextRefreshDue();
    }

    public void setNextRefreshDue(long t) {
        this.webCamPanel.setNextRefreshDue(t);
    }

    public void run() {
        try {
            this.webCamPanel.setNextRefreshDue(System.currentTimeMillis());
            while (true) {
                try {
                    long dt = System.currentTimeMillis() - this.webCamPanel.getNextRefreshDue();
                    if (dt > 0L) {
                        if (this.webCamPanel.isInTime(dt / 1000L)) {
                            System.out.println("tick!");
                            this.webCamPanel.refresh();
                            this.webCamPanel.setNextRefreshDue();
                        } else {
                            this.webCamPanel.resetPixelListeners();
                            do {
                                this.webCamPanel.setNextRefreshDue(this.webCamPanel.getNextRefreshDue() + this.webCamPanel.getIntervalMs());
                            } while (this.webCamPanel.getNextRefreshDue() < System.currentTimeMillis());
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException dt) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void close() {
        try {
            this.savePreferences();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        System.exit(0);
    }

    public void stateChanged(ChangeEvent e) {
        this.setInterval(this.slider.getTime());
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.close();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public static void main(String[] args) {
        try {
            new OnePixelWebCam();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

