/*
 * Decompiled with CFR 0.152.
 */
package org.curiositycollective.onepixelwebcam;

import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import org.curiositycollective.onepixelwebcam.TimeIncrement;

public class TimeSlider
extends JSlider {
    private TimeIncrement[] times = new TimeIncrement[]{new TimeIncrement(60L, "1 minute"), new TimeIncrement(3600L, "1 hour"), new TimeIncrement(86400L, "1 day"), new TimeIncrement(2551442L, "1 lunar cycle"), new TimeIncrement(31536000L, "1 year")};

    public TimeSlider(long interval) {
        this.setMinimum(0);
        this.setMaximum(this.times.length - 1);
        this.setMajorTickSpacing(1);
        this.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        int n = 0;
        while (n < this.times.length) {
            labelTable.put(new Integer(n), new JLabel(this.times[n].label));
            if (this.times[n].milliseconds == interval) {
                this.setValue(n);
            }
            ++n;
        }
        this.setLabelTable(labelTable);
        this.setPaintLabels(true);
    }

    public long getTime() {
        long t = this.times[this.getValue()].milliseconds;
        return t;
    }
}

