/*
 * Decompiled with CFR 0.152.
 */
package org.curiositycollective.onepixelwebcam;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import org.curiositycollective.onepixelwebcam.PixelListener;

public class WebCamCanvas
extends Canvas
implements MouseListener {
    private URL thisURL;
    private BufferedImage image;
    private Vector pixelListeners = new Vector();
    private long thisInterval = 900L;
    private long nextRefreshDue = 0L;
    private Point onePixel = null;

    public WebCamCanvas(URL url, Point onePixel) {
        this.init(url, onePixel);
    }

    public WebCamCanvas(String url) throws MalformedURLException {
        this.init(new URL(url), null);
    }

    public void refresh() {
        try {
            this.load();
            this.invalidate();
            this.repaint();
            this.updatePixelListeners(this.getOnePixel());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void refresh(URL newURL) {
        this.setURL(newURL);
        this.refresh();
    }

    public Color getOnePixel() {
        Color color = null;
        if (this.onePixel != null) {
            color = new Color(this.image.getRGB(this.onePixel.x, this.onePixel.y));
        }
        return color;
    }

    public Point getOnePixelLocation() {
        return this.onePixel;
    }

    public Image getImage() {
        return this.image;
    }

    private void init(URL url, Point onePixel) {
        this.addMouseListener(this);
        this.setURL(url);
        this.setOnePixelLocation(onePixel);
        this.refresh();
    }

    public void setURL(URL url) {
        this.thisURL = url;
        this.onePixel = null;
    }

    public URL getURL() {
        return this.thisURL;
    }

    public void savePreferences(BufferedWriter writer) throws IOException {
        try {
            writer.write(String.valueOf(this.thisURL.toString()) + '\t' + this.onePixel.x + '\t' + this.onePixel.y + '\t' + this.thisInterval + '\t' + this.nextRefreshDue);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void load() throws Exception {
        if (this.thisURL != null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image tempImage = toolkit.createImage(this.thisURL);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(tempImage, 0);
            mediaTracker.waitForID(0);
            int webcamWidth = tempImage.getWidth(null);
            int webcamHeight = tempImage.getHeight(null);
            this.image = new BufferedImage(webcamWidth, webcamHeight, 1);
            Graphics2D bufImageGraphics = this.image.createGraphics();
            bufImageGraphics.drawImage(tempImage, 0, 0, null);
        }
    }

    public void addPixelListener(PixelListener listener) {
        this.pixelListeners.addElement(listener);
    }

    public void updatePixelListeners(Color c) {
        if (c != null) {
            int n = 0;
            while (n < this.pixelListeners.size()) {
                ((PixelListener)this.pixelListeners.elementAt(n)).pixelUpdate(c);
                ++n;
            }
        }
    }

    public void resetPixelListeners() {
        int n = 0;
        while (n < this.pixelListeners.size()) {
            ((PixelListener)this.pixelListeners.elementAt(n)).pixelReset();
            ++n;
        }
    }

    public Dimension getMinimumSize() {
        Dimension minimumSize = new Dimension(300, 300);
        return minimumSize;
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = null;
        preferredSize = this.image != null ? new Dimension(this.image.getWidth(null), this.image.getHeight(null)) : this.getMinimumSize();
        return preferredSize;
    }

    private float getScale() {
        int webcamHeight;
        float scale = 1.0f;
        int webcamWidth = this.image.getWidth(null);
        scale = webcamWidth > (webcamHeight = this.image.getHeight(null)) ? (float)this.getWidth() / (float)webcamWidth : (float)this.getHeight() / (float)webcamHeight;
        return scale;
    }

    public void paint(Graphics graphics) {
        Graphics2D g2d = (Graphics2D)graphics;
        if (this.image == null) {
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            float scale = this.getScale();
            AffineTransform t = new AffineTransform(scale, 0.0f, 0.0f, scale, 0.0f, 0.0f);
            g2d.transform(t);
            g2d.drawImage((Image)this.image, 0, 0, null);
            if (this.onePixel != null) {
                g2d.setColor(Color.black);
                g2d.fillRect(this.onePixel.x - 10, this.onePixel.y - 10, 20, 20);
                g2d.setColor(Color.white);
                g2d.fillRect(this.onePixel.x - 9, this.onePixel.y - 9, 18, 18);
                g2d.setColor(this.getOnePixel());
                g2d.fillRect(this.onePixel.x - 8, this.onePixel.y - 8, 16, 16);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        System.out.println("click!");
        this.onePixel = e.getPoint();
        System.out.println(this.onePixel);
        float scale = this.getScale();
        int x = (int)((float)this.onePixel.x / scale);
        int y = (int)((float)this.onePixel.y / scale);
        if (x > 0 && x < this.image.getWidth(null) && y > 0 && y < this.image.getHeight(null)) {
            this.setOnePixelLocation(x, y);
            System.out.println(this.onePixel);
            this.invalidate();
            this.repaint();
            this.resetPixelListeners();
            this.updatePixelListeners(this.getOnePixel());
        }
    }

    public void setOnePixelLocation(Point p) {
        if (p != null) {
            this.setOnePixelLocation(p.x, p.y);
        }
    }

    public void setOnePixelLocation(int x, int y) {
        if (this.onePixel == null) {
            this.onePixel = new Point();
        }
        this.onePixel.setLocation(x, y);
    }

    public long getInterval() {
        return this.thisInterval;
    }

    public long getIntervalMs() {
        return this.getInterval() * 1000L;
    }

    public void setInterval(long t) {
        if (this.thisInterval != t) {
            System.out.println("WebCamCanvas::setInterval");
            this.thisInterval = t;
            this.updateNextRefreshDue();
        }
    }

    public long getNextRefreshDue() {
        return this.nextRefreshDue;
    }

    public void setNextRefreshDue(long t) {
        this.nextRefreshDue = t;
    }

    public void updateNextRefreshDue() {
        this.nextRefreshDue = System.currentTimeMillis() + this.getIntervalMs();
    }
}

