/*
 * Decompiled with CFR 0.152.
 */
package org.curiositycollective.onepixelwebcam;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.curiositycollective.onepixelwebcam.ImageURLField;
import org.curiositycollective.onepixelwebcam.PixelListener;
import org.curiositycollective.onepixelwebcam.WebCamCanvas;

public class WebCamPanel
extends JPanel
implements ActionListener {
    private WebCamCanvas image = null;
    private ImageURLField urlField = null;

    public WebCamPanel(URL imageURL, Point onePixel) {
        super(new BorderLayout());
        this.init(imageURL, onePixel);
    }

    public void init(URL imageURL, Point onePixel) {
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Find a Webcam & Pick a Pixel"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.urlField = new ImageURLField(imageURL, 300, 30);
        this.add((Component)this.urlField, "First");
        this.urlField.addActionListener(this);
        this.image = new WebCamCanvas(imageURL, onePixel);
        this.add(this.image);
    }

    public void addPixelListener(PixelListener listener) {
        this.image.addPixelListener(listener);
    }

    public void savePreferences(BufferedWriter writer) throws IOException {
        if (this.image != null) {
            this.image.savePreferences(writer);
        }
    }

    public void refresh() {
        this.image.refresh();
    }

    public void refresh(URL newURL) {
        this.image.refresh(newURL);
    }

    public void actionPerformed(ActionEvent ae) {
        try {
            this.image.resetPixelListeners();
            this.urlField.setURL(ae.getActionCommand());
            this.refresh(this.urlField.getImageURL());
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void setOnePixelLocation(Point p) {
        this.image.setOnePixelLocation(p);
    }

    public long getInterval() {
        return this.image.getInterval();
    }

    public void setInterval(long t) {
        this.image.setInterval(t);
    }

    public long getIntervalMs() {
        return this.image.getIntervalMs();
    }

    public boolean isInTime(long duration) {
        boolean result = false;
        result = (float)duration < (float)this.getInterval() * 0.02f;
        return result;
    }

    public void resetPixelListeners() {
        this.image.resetPixelListeners();
    }

    public long getNextRefreshDue() {
        return this.image.getNextRefreshDue();
    }

    public void setNextRefreshDue(long t) {
        this.image.setNextRefreshDue(t);
    }

    public void setNextRefreshDue() {
        this.image.updateNextRefreshDue();
    }
}

